@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <form class="form-horizontal" name="import-beneficiary-form" id="import-beneficiary-form"
                                    action="{{ $data->route }}" data-parsley-validate="" method="POST">
                                    @csrf
                                    @method($data->method)
                                    <input type="hidden" value="{{ $data->rows }}" name="rows">
                                    <table class="table import-beneficiary" id="import-beneficiary">
                                        <thead>
                                            <tr>
                                                <th class="wd-5p">S.No</th>
                                                @for ($i = 0; $i < $data->columnCount; $i++)
                                                    <th>
                                                        <select class="form-control wd-150"
                                                            name="headerColumn[{{ $i }}]" required="">
                                                            @foreach ($data->headers as $key => $header)
                                                                <option value="{{ $key }}">{{ $header }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </th>
                                                @endfor
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($data->rows as $key => $row)
                                                @if ($key != 0)
                                                    <tr>
                                                        <td>{{ $key }}</td>
                                                        <td>
                                                            {{ isset($row[0]) ? $row[0] : '' }}
                                                        </td>
                                                        <td>
                                                            {{ isset($row[1]) ? $row[1] : '' }}
                                                        </td>
                                                        <td>
                                                            {{ isset($row[2]) ? $row[2] : '' }}
                                                        </td>
                                                        <td>
                                                            {{ isset($row[3]) ? $row[3] : '' }}
                                                        </td>
                                                        <td>
                                                            {{ isset($row[4]) ? $row[4] : '' }}
                                                        </td>
                                                        <td>
                                                            {{ isset($row[5]) ? $row[5] : '' }}
                                                        </td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <div class="form-group">
                                        <div class="row row-sm">
                                            <div class="col-md-9">
                                                <button class="btn ripple btn-success">
                                                    <i class="fe fe-check-circle"></i> Submit
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
@endsection
