@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="user-form" id="user-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST">
                                @csrf
                                @method($data->method)

                                <input type="hidden" value="{{ isset($data->userId) ? $data->userId : '' }}" id="userId"
                                    name="userId">
                                <input type="hidden" value="{{ isset($data->id) ? $data->id : '' }}" id="uniqueId"
                                    name="uniqueId">

                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Name</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="name" class="form-control"
                                                value="{{ $data->name }}" required=""
                                                data-parsley-required-message="Name is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Email</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="email" name="email" id="email" class="form-control"
                                                value="{{ $data->email }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Phone</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="phone" name="phone" id="phone" class="form-control"
                                                value="{{ $data->phone }}" required=""
                                                data-parsley-required-message="Phone is required" data-parsley-type="number"
                                                data-parsley-trigger="focusout" data-parsley-checkemail
                                                data-parsley-checkemail-message="Phone no already Exists">
                                        </div>
                                    </div>
                                </div>
                                @if (!isset($data->id))
                                    <div class="form-group ">
                                        <div class="row row-sm">
                                            <div class="col-md-3">
                                                <label class="form-label">Password</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="password" name="password" id="password" class="form-control"
                                                    value="" required=""
                                                    data-parsley-required-message="Password is required">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="row row-sm">
                                            <div class="col-md-3">
                                                <label class="form-label">Confirm Password</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="password" name="ConfirmPassword" class="form-control"
                                                    value="" required=""
                                                    data-parsley-required-message="Confirm Password is required"
                                                    data-parsley-equalto="#password"
                                                    data-parsley-equalto-message="Password and confirm password must be same">
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if (!in_array($data->userId, [1, 2]))
                                    <x-branch-drop-down selected="{{ $data->branch_id }}" />
                                @endif
                                <x-role-drop-down selected="{{ $data->role }}" />

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/user.js') }}?{{ appVersion() }}"></script>
@endsection
